/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.target;

import com.ibm.hwmca.fw.target.CommonTargeting;
import com.ibm.hwmca.fw.target.NextTargetsActionListener;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetActionListener;
import com.ibm.hwmca.fw.target.TargetRetriever;
import com.ibm.hwmca.fw.target.TaskletTargetActionListener;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public abstract class CommonTargetingTasklet
extends PanelTasklet {
    private static final String TRACE_MASKT = "XCMTCTTT";
    private static final String TRACE_MASKF = "XCMTCTTF";
    private static final String TRACE_MASKD = "XCMTCTTD";
    private TaskletTargetActionListener taskletTargetActionListener = null;
    private PanelTaskletResponse currentResponse = null;
    private boolean subTaskletComplete = false;
    private boolean redisplay = true;
    protected String taskid = null;
    protected boolean multipleTargetSelection = false;
    protected int panelType = 1;

    public CommonTargetingTasklet() {
        this.setExplicitTerminate(true);
        Trace.trace(TRACE_MASKT, "<> CommonTargetingTasklet ctor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> CommonTargetingTasklet.service()");
        try {
            this.currentResponse = response;
            if (!request.isInitialRequest()) {
                Trace.trace(TRACE_MASKF, "not the initial request, must need to wait for a subtasklet; subTaskletComplete=" + this.subTaskletComplete);
                CommonTargetingTasklet commonTargetingTasklet = this;
                synchronized (commonTargetingTasklet) {
                    while (!this.subTaskletComplete) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException exc) {}
                    }
                    this.subTaskletComplete = false;
                }
            }
            if (this.redisplay) {
                boolean again = false;
                do {
                    again = false;
                    CommonTargeting ct = null;
                    TargetActionListener action = null;
                    if (this.panelType == 1) {
                        Trace.trace(TRACE_MASKF, "showing action panel");
                        ct = CommonTargeting.showTargetActionPanel(this.getTargetRetriever(), this.getTaskId(), this.allowMultipleTargetSelection(), this);
                        action = ct.getTargetActionListener();
                        Trace.trace(TRACE_MASKF, "action is: " + action);
                    } else {
                        TargetActionListener[] actions = this.getTargetRetriever().getActions(this.getTaskId());
                        if (actions != null && actions.length == 1) {
                            Trace.trace(TRACE_MASKF, "showing selection panel");
                            ct = CommonTargeting.showTargetSelectionPanel(this.getTargetRetriever(), this.getTaskId(), this.allowMultipleTargetSelection(), this);
                            Target[] targets = ct.getSelectedTargets();
                            Trace.trace(TRACE_MASKF, "selected targets is: " + targets);
                            if (targets != null && targets.length > 0) {
                                action = actions[0];
                            }
                        } else {
                            throw new IllegalStateException("No default action specified");
                        }
                    }
                    this.subTaskletComplete = false;
                    if (action == null) continue;
                    Trace.trace(TRACE_MASKF, "action is not null");
                    if (action instanceof TaskletTargetActionListener) {
                        TaskletTargetActionListener ttal;
                        Trace.trace(TRACE_MASKF, "action is a TaskletTargetActionListener");
                        this.taskletTargetActionListener = ttal = (TaskletTargetActionListener)action;
                        Trace.trace(TRACE_MASKF, "calling TaskletTargetActionListener performAction");
                        ttal.performAction(ct.getSelectedTargets(), response, this);
                        continue;
                    }
                    if (action instanceof NextTargetsActionListener) {
                        Trace.trace(TRACE_MASKF, "action is a NextTargetActionListener");
                        boolean actionPerformed = ((NextTargetsActionListener)action).performNextAction(ct.getSelectedTargets(), this);
                        if (actionPerformed) continue;
                        again = true;
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "calling default performAction");
                    ct.performAction();
                } while (again);
                if (response.isResponseSet()) {
                    if (!response.wasRedirected()) {
                        this.postRequest(null, new PanelTaskletRequest());
                        Trace.trace(TRACE_MASKF, "posted request to wait for a subtasklet");
                    }
                } else {
                    response.terminate();
                }
            }
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        finally {
            this.currentResponse = null;
        }
        Trace.trace(TRACE_MASKF, "<- CommonTargetingTasklet.service()");
    }

    protected abstract TargetRetriever getTargetRetriever();

    public String getTaskId() {
        return this.taskid;
    }

    protected void setTaskId(String taskid) {
        this.taskid = taskid;
    }

    public boolean allowMultipleTargetSelection() {
        return this.multipleTargetSelection;
    }

    protected void setMultipleTargetSelection(boolean multipleTargetSelection) {
        this.multipleTargetSelection = multipleTargetSelection;
    }

    public int getPanelType() {
        return this.panelType;
    }

    protected void setPanelType(int panelType) {
        this.panelType = panelType;
    }

    TaskletTargetActionListener getTaskletTargetActionListener() {
        Trace.trace(TRACE_MASKF, "<>CommonTargetingTasklet.getTaskletTargetActionListener returning: " + this.taskletTargetActionListener);
        return this.taskletTargetActionListener;
    }

    void setTaskletTargetActionListener(TaskletTargetActionListener ttal) {
        this.taskletTargetActionListener = ttal;
        Trace.trace(TRACE_MASKF, "<>CommonTargetingTasklet.setTaskletTargetActionListener(" + this.taskletTargetActionListener);
    }

    PanelTaskletResponse getCurrentResponse() {
        return this.currentResponse;
    }

    public void destroy() {
        Trace.trace(TRACE_MASKF, "-> CommonTargetingTasklet.destroy()");
        Trace.trace(TRACE_MASKF, "<- CommonTargetingTasklet.destroy()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSubTaskletComplete(boolean redisplay) {
        Trace.trace(TRACE_MASKF, "-> CommonTargetingTasklet.setSubTaskletComplete()");
        CommonTargetingTasklet commonTargetingTasklet = this;
        synchronized (commonTargetingTasklet) {
            this.subTaskletComplete = true;
            this.redisplay = redisplay;
            this.notifyAll();
        }
        Trace.trace(TRACE_MASKF, "<- CommonTargetingTasklet.setSubTaskletComplete()");
    }
}

